rule Win32_Trojan_BiBiWiper : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BIBIWIPER"
        description         = "Yara rule that detects BiBiWiper trojan."

        tc_detection_type   = "Trojan"
        tc_detection_name   = "BiBiWiper"
        tc_detection_factor = 5

    strings:

        $delete_shadow_copies_p1 = {
            48 89 5C 24 ?? 55 48 8D 6C 24 ?? 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4
            48 89 45 ?? 33 DB 48 C7 44 24 ?? ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 5C 24 ?? 48
            8D 4C 24 ?? 48 89 5C 24 ?? 44 8D 43 ?? E8 ?? ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24
            ?? 48 8B 54 24 ?? 48 0F 43 4C 24 ?? 48 03 D1 48 8D 4C 24 ?? 48 83 7C 24 ?? ?? 48 0F
            43 4C 24 ?? E8 ?? ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24 ?? 48 8D 55 ?? 48 0F 43 4C
            24 ?? 48 2B D1 0F B6 01 88 04 0A 48 8D 49 ?? 84 C0 75 ?? 0F 57 C0 C7 44 24 ?? ?? ??
            ?? ?? 48 8D 45 ?? 45 33 C9 48 89 44 24 ?? 48 8D 55 ?? 48 8D 44 24 ?? 45 33 C0 48 89
            44 24 ?? 33 C9 48 89 5C 24 ?? 48 89 5C 24 ?? 0F 11 45 ?? C7 44 24 ?? ?? ?? ?? ?? 89
            5C 24 ?? 0F 11 44 24 ?? 66 89 5D ?? 0F 11 45 ?? 0F 11 45 ?? 0F 11 45 ?? 0F 11 45 ??
            FF 15 ?? ?? ?? ?? 48 8B 54 24 ?? 48 83 FA ?? 72 ?? 48 8B 4C 24 ?? 48 FF C2 48 8B C1
            48 81 FA ?? ?? ?? ?? 72 ?? 48 8B 49 ?? 48 83 C2 ?? 48 2B C1 48 83 C0 ?? 48 83 F8 ??
            0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 5C 24 ?? 48 8D 15 ?? ?? ??
            ?? 48 89 5C 24 ?? 48 8D 4C 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 7C
            24 ?? ?? 48 8D 4C 24 ?? 48 8B 54 24 ?? 48 0F 43 4C 24 ?? 48 03 D1 48 8D 4C 24 ?? 48
            83 7C 24 ?? ?? 48 0F 43 4C 24 ?? E8 ?? ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24 ?? 48
            8D 55 ?? 48 0F 43 4C 24 ?? 48 2B D1 0F B6 01 88 04 0A 48 8D 49 ?? 84 C0 75 ?? 0F 57
            C0 C7 44 24 ?? ?? ?? ?? ?? 48 8D 45 ?? 45 33 C9 48 89 44 24 ?? 48 8D 55 ?? 48 8D 44
            24 ?? 45 33 C0 48 89 44 24 ?? 33 C9 48 89 5C 24 ?? 48 89 5C 24 ?? 0F 11 45 ?? C7 44
            24 ?? ?? ?? ?? ?? 89 5C 24 ?? 0F 11 44 24 ?? 66 89 5D ?? 0F 11 45 ?? 0F 11 45 ?? 0F
        }

        $delete_shadow_copies_p2 = {
            11 45 ?? 0F 11 45 ?? FF 15 ?? ?? ?? ?? 48 8B 54 24 ?? 48 83 FA ?? 72 ?? 48 8B 4C 24
            ?? 48 FF C2 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 8B 49 ?? 48 83 C2 ?? 48 2B C1 48
            83 C0 ?? 48 83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 5C 24
            ?? 48 8D 15 ?? ?? ?? ?? 48 89 5C 24 ?? 48 8D 4C 24 ?? 48 C7 44 24 ?? ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24 ?? 48 8B 54 24 ?? 48 0F 43 4C 24 ?? 48 03
            D1 48 8D 4C 24 ?? 48 83 7C 24 ?? ?? 48 0F 43 4C 24 ?? E8 ?? ?? ?? ?? 48 83 7C 24 ??
            ?? 48 8D 4C 24 ?? 48 8D 55 ?? 48 0F 43 4C 24 ?? 48 2B D1 90 0F B6 01 88 04 0A 48 8D
            49 ?? 84 C0 75 ?? 0F 57 C0 C7 44 24 ?? ?? ?? ?? ?? 48 8D 45 ?? 45 33 C9 48 89 44 24
            ?? 48 8D 55 ?? 48 8D 44 24 ?? 45 33 C0 48 89 44 24 ?? 33 C9 48 89 5C 24 ?? 48 89 5C
            24 ?? 0F 11 45 ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24 ?? 0F 11 44 24 ?? 66 89 5D ?? 0F
            11 45 ?? 0F 11 45 ?? 0F 11 45 ?? 0F 11 45 ?? FF 15 ?? ?? ?? ?? 48 8B 54 24 ?? 48 83
            FA ?? 72 ?? 48 8B 4C 24 ?? 48 FF C2 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 8B 49 ??
            48 83 C2 ?? 48 2B C1 48 83 C0 ?? 48 83 F8 ?? 0F 87 ?? ?? ?? ?? E8 ?? ?? ?? ?? 41 B8
            ?? ?? ?? ?? 48 89 5C 24 ?? 48 8D 15 ?? ?? ?? ?? 48 89 5C 24 ?? 48 8D 4C 24 ?? 48 C7
            44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24 ?? 48 8B 54 24 ??
            48 0F 43 4C 24 ?? 48 03 D1 48 8D 4C 24 ?? 48 83 7C 24 ?? ?? 48 0F 43 4C 24 ?? E8 ??
            ?? ?? ?? 48 83 7C 24 ?? ?? 48 8D 4C 24 ?? 48 8D 55 ?? 48 0F 43 4C 24 ?? 48 2B D1 90
            0F B6 01 88 04 0A 48 8D 49 ?? 84 C0 75 ?? 0F 57 C0 C7 44 24 ?? ?? ?? ?? ?? 48 8D 45
            ?? 45 33 C9 48 89 44 24 ?? 48 8D 55 ?? 48 8D 44 24 ?? 45 33 C0 48 89 44 24 ?? 33 C9
            48 89 5C 24 ?? 48 89 5C 24 ?? 0F 11 45 ?? C7 44 24 ?? ?? ?? ?? ?? 89 5C 24
        }

        $destroy_files_p1 = {
            48 89 5C 24 ?? 55 56 57 41 54 41 55 41 56 41 57 48 83 EC ?? 48 8B 05 ?? ?? ?? ?? 48
            33 C4 48 89 44 24 ?? 4D 8B E9 4D 8B E0 4C 8B F9 48 63 BC 24 ?? ?? ?? ?? 33 F6 89 74
            24 ?? 48 8B 05 ?? ?? ?? ?? 48 FF C0 48 89 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 48 B8
            ?? ?? ?? ?? ?? ?? ?? ?? 48 F7 E9 48 C1 FA ?? 48 8B C2 48 C1 E8 ?? 48 03 D0 48 69 C2
            ?? ?? ?? ?? 48 3B C8 75 ?? 4C 8B 05 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 8D 0D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 C1 E3 ?? 33 D2 49 8B C4 49 F7 F5 48
            8B E8 48 2B EB 83 FF ?? 7E ?? 48 8D 47 ?? 48 0F AF C3 33 D2 49 F7 F4 EB ?? 48 8B D6
            45 33 C0 49 8B CF E8 ?? ?? ?? ?? 49 8B CF E8 ?? ?? ?? ?? 48 63 C8 49 3B CC 0F 87 ??
            ?? ?? ?? 49 8B C4 48 2B C1 49 8B FC 48 2B F9 48 3B D8 48 0F 42 FB 48 8B CF E8 ?? ??
            ?? ?? 48 89 44 24 ?? 0F 57 C0 4C 63 F7 F3 0F 7F 44 24 ?? 48 89 74 24 ?? 85 FF 74 ??
            48 B8 ?? ?? ?? ?? ?? ?? ?? ?? 4C 3B F0 0F 87 ?? ?? ?? ?? 49 81 FE ?? ?? ?? ?? 72
        }

        $destroy_files_p2 = {
            49 8D 4E ?? 49 3B CE 0F 86 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B C8 48 85 C0 0F 84 ?? ??
            ?? ?? 48 83 C0 ?? 48 83 E0 ?? 48 89 48 ?? EB ?? 49 8B CE E8 ?? ?? ?? ?? 48 89 44 24
            ?? 4A 8D 1C 30 48 89 5C 24 ?? 4D 8B C6 33 D2 48 8B C8 E8 ?? ?? ?? ?? 48 89 5C 24 ??
            C7 44 24 ?? ?? ?? ?? ?? 85 FF 7E ?? 48 8B DE 44 8B F7 66 0F 1F 44 00 ?? BA ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 88 04 0B 48 8D 5B ?? 49 83 EE ?? 75 ?? 4D 85 ED 7E
            ?? 4D 8B CF 41 B8 ?? ?? ?? ?? 48 8B D7 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 49 8B CF E8 ??
            ?? ?? ?? 48 63 C8 48 8D 04 29 48 03 C7 49 3B C4 76 ?? 49 8B FC 48 2B F9 48 2B FD 48
            85 FF 7E ?? 41 B8 ?? ?? ?? ?? 48 8B D5 49 8B CF E8 ?? ?? ?? ?? FF C6 48 63 C6 49 3B
            C5 7C ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? 90 48 8B 4C 24 ?? 48 85 C9 74 ?? 48 8B 54 24
            ?? 48 2B D1 48 8B C1 48 81 FA ?? ?? ?? ?? 72 ?? 48 83 C2 ?? 48 8B 49 ?? 48 2B C1 48
            83 C0 ?? 48 83 F8 ?? 77 ?? E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 33 CC E8 ?? ?? ?? ?? 48
            8B 9C 24 ?? ?? ?? ?? 48 83 C4 ?? 41 5F 41 5E 41 5D 41 5C 5F 5E 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($delete_shadow_copies_p*)
        ) and
        (
            all of ($destroy_files_p*)
        )
}